package zio.aws.rum.model
import scala.jdk.CollectionConverters._
sealed trait StateEnum {
  def unwrap: software.amazon.awssdk.services.rum.model.StateEnum
}
object StateEnum {
  def wrap(
      value: software.amazon.awssdk.services.rum.model.StateEnum
  ): zio.aws.rum.model.StateEnum = value match {
    case software.amazon.awssdk.services.rum.model.StateEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rum.model.StateEnum.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.rum.model.StateEnum.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.rum.model.StateEnum.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.rum.model.StateEnum {
    override def unwrap: software.amazon.awssdk.services.rum.model.StateEnum =
      software.amazon.awssdk.services.rum.model.StateEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.rum.model.StateEnum {
    override def unwrap: software.amazon.awssdk.services.rum.model.StateEnum =
      software.amazon.awssdk.services.rum.model.StateEnum.CREATED
  }
  case object DELETING extends zio.aws.rum.model.StateEnum {
    override def unwrap: software.amazon.awssdk.services.rum.model.StateEnum =
      software.amazon.awssdk.services.rum.model.StateEnum.DELETING
  }
  case object ACTIVE extends zio.aws.rum.model.StateEnum {
    override def unwrap: software.amazon.awssdk.services.rum.model.StateEnum =
      software.amazon.awssdk.services.rum.model.StateEnum.ACTIVE
  }
}
