package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.QueryTimestamp
import scala.jdk.CollectionConverters._
final case class TimeRange(
    after: QueryTimestamp,
    before: Optional[QueryTimestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rum.model.TimeRange = {
    import TimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.TimeRange
      .builder()
      .after(QueryTimestamp.unwrap(after): java.lang.Long)
      .optionallyWith(
        before.map(value => QueryTimestamp.unwrap(value): java.lang.Long)
      )(_.before)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.TimeRange.ReadOnly =
    zio.aws.rum.model.TimeRange.wrap(buildAwsValue())
}
object TimeRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.TimeRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.TimeRange =
      zio.aws.rum.model.TimeRange(after, before.map(value => value))
    def after: QueryTimestamp
    def before: Optional[QueryTimestamp]
    def getAfter: ZIO[Any, Nothing, QueryTimestamp] = ZIO.succeed(after)
    def getBefore: ZIO[Any, AwsError, QueryTimestamp] =
      AwsError.unwrapOptionField("before", before)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.TimeRange
  ) extends zio.aws.rum.model.TimeRange.ReadOnly {
    override val after: QueryTimestamp =
      zio.aws.rum.model.primitives.QueryTimestamp(impl.after())
    override val before: Optional[QueryTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.before())
      .map(value => zio.aws.rum.model.primitives.QueryTimestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.TimeRange
  ): zio.aws.rum.model.TimeRange.ReadOnly = new Wrapper(impl)
}
