package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{AppMonitorName, AppMonitorDomain}
import scala.jdk.CollectionConverters._
final case class UpdateAppMonitorRequest(
    appMonitorConfiguration: Optional[
      zio.aws.rum.model.AppMonitorConfiguration
    ] = Optional.Absent,
    customEvents: Optional[zio.aws.rum.model.CustomEvents] = Optional.Absent,
    cwLogEnabled: Optional[Boolean] = Optional.Absent,
    domain: Optional[AppMonitorDomain] = Optional.Absent,
    name: AppMonitorName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.UpdateAppMonitorRequest = {
    import UpdateAppMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.UpdateAppMonitorRequest
      .builder()
      .optionallyWith(
        appMonitorConfiguration.map(value => value.buildAwsValue())
      )(_.appMonitorConfiguration)
      .optionallyWith(customEvents.map(value => value.buildAwsValue()))(
        _.customEvents
      )
      .optionallyWith(cwLogEnabled.map(value => value: java.lang.Boolean))(
        _.cwLogEnabled
      )
      .optionallyWith(
        domain.map(value => AppMonitorDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .name(AppMonitorName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.UpdateAppMonitorRequest.ReadOnly =
    zio.aws.rum.model.UpdateAppMonitorRequest.wrap(buildAwsValue())
}
object UpdateAppMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.UpdateAppMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.UpdateAppMonitorRequest =
      zio.aws.rum.model.UpdateAppMonitorRequest(
        appMonitorConfiguration.map(value => value.asEditable),
        customEvents.map(value => value.asEditable),
        cwLogEnabled.map(value => value),
        domain.map(value => value),
        name
      )
    def appMonitorConfiguration
        : Optional[zio.aws.rum.model.AppMonitorConfiguration.ReadOnly]
    def customEvents: Optional[zio.aws.rum.model.CustomEvents.ReadOnly]
    def cwLogEnabled: Optional[Boolean]
    def domain: Optional[AppMonitorDomain]
    def name: AppMonitorName
    def getAppMonitorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rum.model.AppMonitorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "appMonitorConfiguration",
      appMonitorConfiguration
    )
    def getCustomEvents
        : ZIO[Any, AwsError, zio.aws.rum.model.CustomEvents.ReadOnly] =
      AwsError.unwrapOptionField("customEvents", customEvents)
    def getCwLogEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cwLogEnabled", cwLogEnabled)
    def getDomain: ZIO[Any, AwsError, AppMonitorDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getName: ZIO[Any, Nothing, AppMonitorName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.UpdateAppMonitorRequest
  ) extends zio.aws.rum.model.UpdateAppMonitorRequest.ReadOnly {
    override val appMonitorConfiguration
        : Optional[zio.aws.rum.model.AppMonitorConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appMonitorConfiguration())
        .map(value => zio.aws.rum.model.AppMonitorConfiguration.wrap(value))
    override val customEvents
        : Optional[zio.aws.rum.model.CustomEvents.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEvents())
        .map(value => zio.aws.rum.model.CustomEvents.wrap(value))
    override val cwLogEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cwLogEnabled())
      .map(value => value: Boolean)
    override val domain: Optional[AppMonitorDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.rum.model.primitives.AppMonitorDomain(value))
    override val name: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.UpdateAppMonitorRequest
  ): zio.aws.rum.model.UpdateAppMonitorRequest.ReadOnly = new Wrapper(impl)
}
