package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{
  MetricDefinitionId,
  DestinationArn,
  AppMonitorName
}
import scala.jdk.CollectionConverters._
final case class UpdateRumMetricDefinitionRequest(
    appMonitorName: AppMonitorName,
    destination: zio.aws.rum.model.MetricDestination,
    destinationArn: Optional[DestinationArn] = Optional.Absent,
    metricDefinition: zio.aws.rum.model.MetricDefinitionRequest,
    metricDefinitionId: MetricDefinitionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.UpdateRumMetricDefinitionRequest = {
    import UpdateRumMetricDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.UpdateRumMetricDefinitionRequest
      .builder()
      .appMonitorName(AppMonitorName.unwrap(appMonitorName): java.lang.String)
      .destination(destination.unwrap)
      .optionallyWith(
        destinationArn.map(value =>
          DestinationArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .metricDefinition(metricDefinition.buildAwsValue())
      .metricDefinitionId(
        MetricDefinitionId.unwrap(metricDefinitionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.rum.model.UpdateRumMetricDefinitionRequest.ReadOnly =
    zio.aws.rum.model.UpdateRumMetricDefinitionRequest.wrap(buildAwsValue())
}
object UpdateRumMetricDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.UpdateRumMetricDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.UpdateRumMetricDefinitionRequest =
      zio.aws.rum.model.UpdateRumMetricDefinitionRequest(
        appMonitorName,
        destination,
        destinationArn.map(value => value),
        metricDefinition.asEditable,
        metricDefinitionId
      )
    def appMonitorName: AppMonitorName
    def destination: zio.aws.rum.model.MetricDestination
    def destinationArn: Optional[DestinationArn]
    def metricDefinition: zio.aws.rum.model.MetricDefinitionRequest.ReadOnly
    def metricDefinitionId: MetricDefinitionId
    def getAppMonitorName: ZIO[Any, Nothing, AppMonitorName] =
      ZIO.succeed(appMonitorName)
    def getDestination: ZIO[Any, Nothing, zio.aws.rum.model.MetricDestination] =
      ZIO.succeed(destination)
    def getDestinationArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getMetricDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.rum.model.MetricDefinitionRequest.ReadOnly
    ] = ZIO.succeed(metricDefinition)
    def getMetricDefinitionId: ZIO[Any, Nothing, MetricDefinitionId] =
      ZIO.succeed(metricDefinitionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.UpdateRumMetricDefinitionRequest
  ) extends zio.aws.rum.model.UpdateRumMetricDefinitionRequest.ReadOnly {
    override val appMonitorName: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.appMonitorName())
    override val destination: zio.aws.rum.model.MetricDestination =
      zio.aws.rum.model.MetricDestination.wrap(impl.destination())
    override val destinationArn: Optional[DestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value => zio.aws.rum.model.primitives.DestinationArn(value))
    override val metricDefinition
        : zio.aws.rum.model.MetricDefinitionRequest.ReadOnly =
      zio.aws.rum.model.MetricDefinitionRequest.wrap(impl.metricDefinition())
    override val metricDefinitionId: MetricDefinitionId =
      zio.aws.rum.model.primitives.MetricDefinitionId(impl.metricDefinitionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.UpdateRumMetricDefinitionRequest
  ): zio.aws.rum.model.UpdateRumMetricDefinitionRequest.ReadOnly = new Wrapper(
    impl
  )
}
