package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{
  UserDetailsUserIdString,
  UserDetailsSessionIdString
}
import scala.jdk.CollectionConverters._
final case class UserDetails(
    sessionId: Optional[UserDetailsSessionIdString] = Optional.Absent,
    userId: Optional[UserDetailsUserIdString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rum.model.UserDetails = {
    import UserDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.UserDetails
      .builder()
      .optionallyWith(
        sessionId.map(value =>
          UserDetailsSessionIdString.unwrap(value): java.lang.String
        )
      )(_.sessionId)
      .optionallyWith(
        userId.map(value =>
          UserDetailsUserIdString.unwrap(value): java.lang.String
        )
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.UserDetails.ReadOnly =
    zio.aws.rum.model.UserDetails.wrap(buildAwsValue())
}
object UserDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.UserDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.UserDetails = zio.aws.rum.model
      .UserDetails(sessionId.map(value => value), userId.map(value => value))
    def sessionId: Optional[UserDetailsSessionIdString]
    def userId: Optional[UserDetailsUserIdString]
    def getSessionId: ZIO[Any, AwsError, UserDetailsSessionIdString] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getUserId: ZIO[Any, AwsError, UserDetailsUserIdString] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.UserDetails
  ) extends zio.aws.rum.model.UserDetails.ReadOnly {
    override val sessionId: Optional[UserDetailsSessionIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionId())
        .map(value =>
          zio.aws.rum.model.primitives.UserDetailsSessionIdString(value)
        )
    override val userId: Optional[UserDetailsUserIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userId())
        .map(value =>
          zio.aws.rum.model.primitives.UserDetailsUserIdString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.UserDetails
  ): zio.aws.rum.model.UserDetails.ReadOnly = new Wrapper(impl)
}
