package zio.aws.rum
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.rum.model.primitives.{
  EventData,
  Url,
  TagValue,
  MetricDefinitionId,
  DimensionKey,
  QueryFilterValue,
  DimensionName,
  TagKey
}
import zio.aws.rum.model.primitives.IdentityPoolId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AppMonitorDomain extends Subtype[String]
    type AppMonitorDomain = zio.aws.rum.model.primitives.AppMonitorDomain.Type
    object AppMonitorId extends Subtype[String]
    type AppMonitorId = zio.aws.rum.model.primitives.AppMonitorId.Type
    object AppMonitorName extends Subtype[String]
    type AppMonitorName = zio.aws.rum.model.primitives.AppMonitorName.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.rum.model.primitives.Arn.Type
    object DestinationArn extends Subtype[String]
    type DestinationArn = zio.aws.rum.model.primitives.DestinationArn.Type
    object DimensionKey extends Subtype[String]
    type DimensionKey = zio.aws.rum.model.primitives.DimensionKey.Type
    object DimensionName extends Subtype[String]
    type DimensionName = zio.aws.rum.model.primitives.DimensionName.Type
    object EventData extends Subtype[String]
    type EventData = zio.aws.rum.model.primitives.EventData.Type
    object EventPattern extends Subtype[String]
    type EventPattern = zio.aws.rum.model.primitives.EventPattern.Type
    object ISOTimestampString extends Subtype[String]
    type ISOTimestampString =
      zio.aws.rum.model.primitives.ISOTimestampString.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.rum.model.primitives.IamRoleArn.Type
    object IdentityPoolId extends Subtype[String]
    type IdentityPoolId = zio.aws.rum.model.primitives.IdentityPoolId.Type
    object JsonValue extends Subtype[String]
    type JsonValue = zio.aws.rum.model.primitives.JsonValue.Type
    object MaxQueryResults extends Subtype[Int]
    type MaxQueryResults = zio.aws.rum.model.primitives.MaxQueryResults.Type
    object MaxResultsInteger extends Subtype[Int]
    type MaxResultsInteger = zio.aws.rum.model.primitives.MaxResultsInteger.Type
    object MetricDefinitionId extends Subtype[String]
    type MetricDefinitionId =
      zio.aws.rum.model.primitives.MetricDefinitionId.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.rum.model.primitives.MetricName.Type
    object Namespace extends Subtype[String]
    type Namespace = zio.aws.rum.model.primitives.Namespace.Type
    object PutRumEventsRequestBatchIdString extends Subtype[String]
    type PutRumEventsRequestBatchIdString =
      zio.aws.rum.model.primitives.PutRumEventsRequestBatchIdString.Type
    object PutRumEventsRequestIdString extends Subtype[String]
    type PutRumEventsRequestIdString =
      zio.aws.rum.model.primitives.PutRumEventsRequestIdString.Type
    object QueryFilterKey extends Subtype[String]
    type QueryFilterKey = zio.aws.rum.model.primitives.QueryFilterKey.Type
    object QueryFilterValue extends Subtype[String]
    type QueryFilterValue = zio.aws.rum.model.primitives.QueryFilterValue.Type
    object QueryTimestamp extends Subtype[Long]
    type QueryTimestamp = zio.aws.rum.model.primitives.QueryTimestamp.Type
    object RumEventIdString extends Subtype[String]
    type RumEventIdString = zio.aws.rum.model.primitives.RumEventIdString.Type
    object SessionSampleRate extends Subtype[Double]
    type SessionSampleRate = zio.aws.rum.model.primitives.SessionSampleRate.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.rum.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.rum.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.rum.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.rum.model.primitives.Token.Type
    object UnitLabel extends Subtype[String]
    type UnitLabel = zio.aws.rum.model.primitives.UnitLabel.Type
    object Url extends Subtype[String]
    type Url = zio.aws.rum.model.primitives.Url.Type
    object UserDetailsSessionIdString extends Subtype[String]
    type UserDetailsSessionIdString =
      zio.aws.rum.model.primitives.UserDetailsSessionIdString.Type
    object UserDetailsUserIdString extends Subtype[String]
    type UserDetailsUserIdString =
      zio.aws.rum.model.primitives.UserDetailsUserIdString.Type
    object ValueKey extends Subtype[String]
    type ValueKey = zio.aws.rum.model.primitives.ValueKey.Type
  }
  type AppMonitorSummaryList = List[zio.aws.rum.model.AppMonitorSummary]
  type BatchCreateRumMetricDefinitionsErrors =
    List[zio.aws.rum.model.BatchCreateRumMetricDefinitionsError]
  type BatchDeleteRumMetricDefinitionsErrors =
    List[zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError]
  type DimensionKeysMap = Map[DimensionKey, DimensionName]
  type EventDataList = List[EventData]
  type FavoritePages = List[String]
  type MetricDefinitionIds = List[MetricDefinitionId]
  type MetricDefinitions = List[zio.aws.rum.model.MetricDefinition]
  type MetricDefinitionsRequest =
    List[zio.aws.rum.model.MetricDefinitionRequest]
  type MetricDestinationSummaryList =
    List[zio.aws.rum.model.MetricDestinationSummary]
  type Pages = List[Url]
  type QueryFilterValueList = List[QueryFilterValue]
  type QueryFilters = List[zio.aws.rum.model.QueryFilter]
  type RumEventList = List[zio.aws.rum.model.RumEvent]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type Telemetries = List[zio.aws.rum.model.Telemetry]
}
