package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AbortMultipartUploadResponse(
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse = {
    import AbortMultipartUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AbortMultipartUploadResponse.ReadOnly =
    zio.aws.s3.model.AbortMultipartUploadResponse.wrap(buildAwsValue())
}
object AbortMultipartUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AbortMultipartUploadResponse =
      zio.aws.s3.model
        .AbortMultipartUploadResponse(requestCharged.map(value => value))
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse
  ) extends zio.aws.s3.model.AbortMultipartUploadResponse.ReadOnly {
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse
  ): zio.aws.s3.model.AbortMultipartUploadResponse.ReadOnly = new Wrapper(impl)
}
