package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AnalyticsExportDestination(
    s3BucketDestination: zio.aws.s3.model.AnalyticsS3BucketDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AnalyticsExportDestination = {
    import AnalyticsExportDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AnalyticsExportDestination
      .builder()
      .s3BucketDestination(s3BucketDestination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.AnalyticsExportDestination.ReadOnly =
    zio.aws.s3.model.AnalyticsExportDestination.wrap(buildAwsValue())
}
object AnalyticsExportDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AnalyticsExportDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.AnalyticsExportDestination =
      zio.aws.s3.model
        .AnalyticsExportDestination(s3BucketDestination.asEditable)
    def s3BucketDestination
        : zio.aws.s3.model.AnalyticsS3BucketDestination.ReadOnly
    def getS3BucketDestination: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.AnalyticsS3BucketDestination.ReadOnly
    ] = ZIO.succeed(s3BucketDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsExportDestination
  ) extends zio.aws.s3.model.AnalyticsExportDestination.ReadOnly {
    override val s3BucketDestination
        : zio.aws.s3.model.AnalyticsS3BucketDestination.ReadOnly =
      zio.aws.s3.model.AnalyticsS3BucketDestination
        .wrap(impl.s3BucketDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsExportDestination
  ): zio.aws.s3.model.AnalyticsExportDestination.ReadOnly = new Wrapper(impl)
}
