package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait AnalyticsS3ExportFileFormat {
  def unwrap
      : software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat
}
object AnalyticsS3ExportFileFormat {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat
  ): zio.aws.s3.model.AnalyticsS3ExportFileFormat = value match {
    case software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.AnalyticsS3ExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat =
      software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.s3.model.AnalyticsS3ExportFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat =
      software.amazon.awssdk.services.s3.model.AnalyticsS3ExportFileFormat.CSV
  }
}
