package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait BucketAccelerateStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.BucketAccelerateStatus
}
object BucketAccelerateStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.BucketAccelerateStatus
  ): zio.aws.s3.model.BucketAccelerateStatus = value match {
    case software.amazon.awssdk.services.s3.model.BucketAccelerateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.BucketAccelerateStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.BucketAccelerateStatus.SUSPENDED =>
      val r = Suspended
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.BucketAccelerateStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketAccelerateStatus =
      software.amazon.awssdk.services.s3.model.BucketAccelerateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3.model.BucketAccelerateStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketAccelerateStatus =
      software.amazon.awssdk.services.s3.model.BucketAccelerateStatus.ENABLED
  }
  case object Suspended extends zio.aws.s3.model.BucketAccelerateStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketAccelerateStatus =
      software.amazon.awssdk.services.s3.model.BucketAccelerateStatus.SUSPENDED
  }
}
