package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BucketLifecycleConfiguration(
    rules: Iterable[zio.aws.s3.model.LifecycleRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration = {
    import BucketLifecycleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration
      .builder()
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.BucketLifecycleConfiguration.ReadOnly =
    zio.aws.s3.model.BucketLifecycleConfiguration.wrap(buildAwsValue())
}
object BucketLifecycleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.BucketLifecycleConfiguration =
      zio.aws.s3.model.BucketLifecycleConfiguration(rules.map { item =>
        item.asEditable
      })
    def rules: List[zio.aws.s3.model.LifecycleRule.ReadOnly]
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.s3.model.LifecycleRule.ReadOnly]] =
      ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration
  ) extends zio.aws.s3.model.BucketLifecycleConfiguration.ReadOnly {
    override val rules: List[zio.aws.s3.model.LifecycleRule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.s3.model.LifecycleRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration
  ): zio.aws.s3.model.BucketLifecycleConfiguration.ReadOnly = new Wrapper(impl)
}
