package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait CompressionType {
  def unwrap: software.amazon.awssdk.services.s3.model.CompressionType
}
object CompressionType {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.CompressionType
  ): zio.aws.s3.model.CompressionType = value match {
    case software.amazon.awssdk.services.s3.model.CompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.CompressionType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.s3.model.CompressionType.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.s3.model.CompressionType.BZIP2 =>
      val r = BZIP2
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.CompressionType =
      software.amazon.awssdk.services.s3.model.CompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.s3.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.CompressionType =
      software.amazon.awssdk.services.s3.model.CompressionType.NONE
  }
  case object GZIP extends zio.aws.s3.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.CompressionType =
      software.amazon.awssdk.services.s3.model.CompressionType.GZIP
  }
  case object BZIP2 extends zio.aws.s3.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.CompressionType =
      software.amazon.awssdk.services.s3.model.CompressionType.BZIP2
  }
}
