package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, AnalyticsId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBucketAnalyticsConfigurationRequest(
    bucket: BucketName,
    id: AnalyticsId,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest = {
    import DeleteBucketAnalyticsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(AnalyticsId.unwrap(id): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.DeleteBucketAnalyticsConfigurationRequest.ReadOnly =
    zio.aws.s3.model.DeleteBucketAnalyticsConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteBucketAnalyticsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteBucketAnalyticsConfigurationRequest =
      zio.aws.s3.model.DeleteBucketAnalyticsConfigurationRequest(
        bucket,
        id,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def id: AnalyticsId
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, AnalyticsId] = ZIO.succeed(id)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest
  ) extends zio.aws.s3.model.DeleteBucketAnalyticsConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: AnalyticsId =
      zio.aws.s3.model.primitives.AnalyticsId(impl.id())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest
  ): zio.aws.s3.model.DeleteBucketAnalyticsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
