package zio.aws.s3.model
import zio.aws.s3.model.primitives.{IntelligentTieringId, BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBucketIntelligentTieringConfigurationRequest(
    bucket: BucketName,
    id: IntelligentTieringId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest = {
    import DeleteBucketIntelligentTieringConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(IntelligentTieringId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest.ReadOnly =
    zio.aws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteBucketIntelligentTieringConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest =
      zio.aws.s3.model
        .DeleteBucketIntelligentTieringConfigurationRequest(bucket, id)
    def bucket: BucketName
    def id: IntelligentTieringId
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, IntelligentTieringId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
  ) extends zio.aws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: IntelligentTieringId =
      zio.aws.s3.model.primitives.IntelligentTieringId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
  ): zio.aws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
