package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  BypassGovernanceRetention,
  MFA,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteObjectRequest(
    bucket: BucketName,
    key: ObjectKey,
    mfa: Optional[MFA] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    bypassGovernanceRetention: Optional[BypassGovernanceRetention] =
      Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectRequest = {
    import DeleteObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(mfa.map(value => MFA.unwrap(value): java.lang.String))(
        _.mfa
      )
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        bypassGovernanceRetention.map(value =>
          BypassGovernanceRetention.unwrap(value): java.lang.Boolean
        )
      )(_.bypassGovernanceRetention)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteObjectRequest.ReadOnly =
    zio.aws.s3.model.DeleteObjectRequest.wrap(buildAwsValue())
}
object DeleteObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteObjectRequest =
      zio.aws.s3.model.DeleteObjectRequest(
        bucket,
        key,
        mfa.map(value => value),
        versionId.map(value => value),
        requestPayer.map(value => value),
        bypassGovernanceRetention.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def mfa: Optional[MFA]
    def versionId: Optional[ObjectVersionId]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def bypassGovernanceRetention: Optional[BypassGovernanceRetention]
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getMfa: ZIO[Any, AwsError, MFA] = AwsError.unwrapOptionField("mfa", mfa)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getBypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ) extends zio.aws.s3.model.DeleteObjectRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val mfa: Optional[MFA] = zio.aws.core.internal
      .optionalFromNullable(impl.mfa())
      .map(value => zio.aws.s3.model.primitives.MFA(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val bypassGovernanceRetention
        : Optional[BypassGovernanceRetention] = zio.aws.core.internal
      .optionalFromNullable(impl.bypassGovernanceRetention())
      .map(value =>
        zio.aws.s3.model.primitives.BypassGovernanceRetention(value)
      )
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ): zio.aws.s3.model.DeleteObjectRequest.ReadOnly = new Wrapper(impl)
}
