package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  DeleteMarkerVersionId,
  DeleteMarker,
  ObjectVersionId,
  ObjectKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletedObject(
    key: Optional[ObjectKey] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    deleteMarker: Optional[DeleteMarker] = Optional.Absent,
    deleteMarkerVersionId: Optional[DeleteMarkerVersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeletedObject = {
    import DeletedObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeletedObject
      .builder()
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        deleteMarker.map(value => DeleteMarker.unwrap(value): java.lang.Boolean)
      )(_.deleteMarker)
      .optionallyWith(
        deleteMarkerVersionId.map(value =>
          DeleteMarkerVersionId.unwrap(value): java.lang.String
        )
      )(_.deleteMarkerVersionId)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeletedObject.ReadOnly =
    zio.aws.s3.model.DeletedObject.wrap(buildAwsValue())
}
object DeletedObject {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.DeletedObject] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeletedObject =
      zio.aws.s3.model.DeletedObject(
        key.map(value => value),
        versionId.map(value => value),
        deleteMarker.map(value => value),
        deleteMarkerVersionId.map(value => value)
      )
    def key: Optional[ObjectKey]
    def versionId: Optional[ObjectVersionId]
    def deleteMarker: Optional[DeleteMarker]
    def deleteMarkerVersionId: Optional[DeleteMarkerVersionId]
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getDeleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarker)
    def getDeleteMarkerVersionId: ZIO[Any, AwsError, DeleteMarkerVersionId] =
      AwsError.unwrapOptionField("deleteMarkerVersionId", deleteMarkerVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeletedObject
  ) extends zio.aws.s3.model.DeletedObject.ReadOnly {
    override val key: Optional[ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val deleteMarker: Optional[DeleteMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteMarker())
      .map(value => zio.aws.s3.model.primitives.DeleteMarker(value))
    override val deleteMarkerVersionId: Optional[DeleteMarkerVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteMarkerVersionId())
        .map(value => zio.aws.s3.model.primitives.DeleteMarkerVersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeletedObject
  ): zio.aws.s3.model.DeletedObject.ReadOnly = new Wrapper(impl)
}
