package zio.aws.s3.model
import zio.aws.s3.model.primitives.{KMSContext, SSEKMSKeyId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Encryption(
    encryptionType: zio.aws.s3.model.ServerSideEncryption,
    kmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    kmsContext: Optional[KMSContext] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Encryption = {
    import Encryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Encryption
      .builder()
      .encryptionType(encryptionType.unwrap)
      .optionallyWith(
        kmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        kmsContext.map(value => KMSContext.unwrap(value): java.lang.String)
      )(_.kmsContext)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Encryption.ReadOnly =
    zio.aws.s3.model.Encryption.wrap(buildAwsValue())
}
object Encryption {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Encryption] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Encryption = zio.aws.s3.model.Encryption(
      encryptionType,
      kmsKeyId.map(value => value),
      kmsContext.map(value => value)
    )
    def encryptionType: zio.aws.s3.model.ServerSideEncryption
    def kmsKeyId: Optional[SSEKMSKeyId]
    def kmsContext: Optional[KMSContext]
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.s3.model.ServerSideEncryption] =
      ZIO.succeed(encryptionType)
    def getKmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getKmsContext: ZIO[Any, AwsError, KMSContext] =
      AwsError.unwrapOptionField("kmsContext", kmsContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Encryption
  ) extends zio.aws.s3.model.Encryption.ReadOnly {
    override val encryptionType: zio.aws.s3.model.ServerSideEncryption =
      zio.aws.s3.model.ServerSideEncryption.wrap(impl.encryptionType())
    override val kmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val kmsContext: Optional[KMSContext] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsContext())
      .map(value => zio.aws.s3.model.primitives.KMSContext(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Encryption
  ): zio.aws.s3.model.Encryption.ReadOnly = new Wrapper(impl)
}
