package zio.aws.s3.model
import zio.aws.s3.model.primitives.ObjectKey
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ErrorDocument(key: ObjectKey) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ErrorDocument = {
    import ErrorDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ErrorDocument
      .builder()
      .key(ObjectKey.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ErrorDocument.ReadOnly =
    zio.aws.s3.model.ErrorDocument.wrap(buildAwsValue())
}
object ErrorDocument {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ErrorDocument] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ErrorDocument =
      zio.aws.s3.model.ErrorDocument(key)
    def key: ObjectKey
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ErrorDocument
  ) extends zio.aws.s3.model.ErrorDocument.ReadOnly {
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ErrorDocument
  ): zio.aws.s3.model.ErrorDocument.ReadOnly = new Wrapper(impl)
}
