package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExistingObjectReplication(
    status: zio.aws.s3.model.ExistingObjectReplicationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ExistingObjectReplication = {
    import ExistingObjectReplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ExistingObjectReplication
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ExistingObjectReplication.ReadOnly =
    zio.aws.s3.model.ExistingObjectReplication.wrap(buildAwsValue())
}
object ExistingObjectReplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ExistingObjectReplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ExistingObjectReplication =
      zio.aws.s3.model.ExistingObjectReplication(status)
    def status: zio.aws.s3.model.ExistingObjectReplicationStatus
    def getStatus
        : ZIO[Any, Nothing, zio.aws.s3.model.ExistingObjectReplicationStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ExistingObjectReplication
  ) extends zio.aws.s3.model.ExistingObjectReplication.ReadOnly {
    override val status: zio.aws.s3.model.ExistingObjectReplicationStatus =
      zio.aws.s3.model.ExistingObjectReplicationStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ExistingObjectReplication
  ): zio.aws.s3.model.ExistingObjectReplication.ReadOnly = new Wrapper(impl)
}
