package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketCorsResponse(
    corsRules: Optional[Iterable[zio.aws.s3.model.CORSRule]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketCorsResponse = {
    import GetBucketCorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketCorsResponse
      .builder()
      .optionallyWith(
        corsRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.corsRules)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketCorsResponse.ReadOnly =
    zio.aws.s3.model.GetBucketCorsResponse.wrap(buildAwsValue())
}
object GetBucketCorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketCorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketCorsResponse =
      zio.aws.s3.model.GetBucketCorsResponse(
        corsRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def corsRules: Optional[List[zio.aws.s3.model.CORSRule.ReadOnly]]
    def getCorsRules
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CORSRule.ReadOnly]] =
      AwsError.unwrapOptionField("corsRules", corsRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketCorsResponse
  ) extends zio.aws.s3.model.GetBucketCorsResponse.ReadOnly {
    override val corsRules: Optional[List[zio.aws.s3.model.CORSRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.corsRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.CORSRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketCorsResponse
  ): zio.aws.s3.model.GetBucketCorsResponse.ReadOnly = new Wrapper(impl)
}
