package zio.aws.s3.model
import zio.aws.s3.model.primitives.{IntelligentTieringId, BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetBucketIntelligentTieringConfigurationRequest(
    bucket: BucketName,
    id: IntelligentTieringId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest = {
    import GetBucketIntelligentTieringConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(IntelligentTieringId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketIntelligentTieringConfigurationRequest.ReadOnly =
    zio.aws.s3.model.GetBucketIntelligentTieringConfigurationRequest
      .wrap(buildAwsValue())
}
object GetBucketIntelligentTieringConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3.model.GetBucketIntelligentTieringConfigurationRequest =
      zio.aws.s3.model
        .GetBucketIntelligentTieringConfigurationRequest(bucket, id)
    def bucket: BucketName
    def id: IntelligentTieringId
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, IntelligentTieringId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest
  ) extends zio.aws.s3.model.GetBucketIntelligentTieringConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: IntelligentTieringId =
      zio.aws.s3.model.primitives.IntelligentTieringId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationRequest
  ): zio.aws.s3.model.GetBucketIntelligentTieringConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
