package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketNotificationConfigurationRequest(
    bucket: BucketName,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest = {
    import GetBucketNotificationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketNotificationConfigurationRequest.ReadOnly =
    zio.aws.s3.model.GetBucketNotificationConfigurationRequest
      .wrap(buildAwsValue())
}
object GetBucketNotificationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketNotificationConfigurationRequest =
      zio.aws.s3.model.GetBucketNotificationConfigurationRequest(
        bucket,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest
  ) extends zio.aws.s3.model.GetBucketNotificationConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest
  ): zio.aws.s3.model.GetBucketNotificationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
