package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketOwnershipControlsResponse(
    ownershipControls: Optional[zio.aws.s3.model.OwnershipControls] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse = {
    import GetBucketOwnershipControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse
      .builder()
      .optionallyWith(ownershipControls.map(value => value.buildAwsValue()))(
        _.ownershipControls
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly =
    zio.aws.s3.model.GetBucketOwnershipControlsResponse.wrap(buildAwsValue())
}
object GetBucketOwnershipControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketOwnershipControlsResponse =
      zio.aws.s3.model.GetBucketOwnershipControlsResponse(
        ownershipControls.map(value => value.asEditable)
      )
    def ownershipControls: Optional[zio.aws.s3.model.OwnershipControls.ReadOnly]
    def getOwnershipControls
        : ZIO[Any, AwsError, zio.aws.s3.model.OwnershipControls.ReadOnly] =
      AwsError.unwrapOptionField("ownershipControls", ownershipControls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse
  ) extends zio.aws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly {
    override val ownershipControls
        : Optional[zio.aws.s3.model.OwnershipControls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownershipControls())
        .map(value => zio.aws.s3.model.OwnershipControls.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse
  ): zio.aws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly = new Wrapper(
    impl
  )
}
