package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketReplicationResponse(
    replicationConfiguration: Optional[
      zio.aws.s3.model.ReplicationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse = {
    import GetBucketReplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse
      .builder()
      .optionallyWith(
        replicationConfiguration.map(value => value.buildAwsValue())
      )(_.replicationConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketReplicationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketReplicationResponse.wrap(buildAwsValue())
}
object GetBucketReplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketReplicationResponse =
      zio.aws.s3.model.GetBucketReplicationResponse(
        replicationConfiguration.map(value => value.asEditable)
      )
    def replicationConfiguration
        : Optional[zio.aws.s3.model.ReplicationConfiguration.ReadOnly]
    def getReplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.ReplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationConfiguration",
      replicationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse
  ) extends zio.aws.s3.model.GetBucketReplicationResponse.ReadOnly {
    override val replicationConfiguration
        : Optional[zio.aws.s3.model.ReplicationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfiguration())
        .map(value => zio.aws.s3.model.ReplicationConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse
  ): zio.aws.s3.model.GetBucketReplicationResponse.ReadOnly = new Wrapper(impl)
}
