package zio.aws.s3.model
import zio.aws.s3.model.primitives.ObjectVersionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetObjectTaggingResponse(
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    tagSet: Iterable[zio.aws.s3.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse = {
    import GetObjectTaggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse
      .builder()
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .tagSet(tagSet.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectTaggingResponse.ReadOnly =
    zio.aws.s3.model.GetObjectTaggingResponse.wrap(buildAwsValue())
}
object GetObjectTaggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectTaggingResponse =
      zio.aws.s3.model.GetObjectTaggingResponse(
        versionId.map(value => value),
        tagSet.map { item =>
          item.asEditable
        }
      )
    def versionId: Optional[ObjectVersionId]
    def tagSet: List[zio.aws.s3.model.Tag.ReadOnly]
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getTagSet: ZIO[Any, Nothing, List[zio.aws.s3.model.Tag.ReadOnly]] =
      ZIO.succeed(tagSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse
  ) extends zio.aws.s3.model.GetObjectTaggingResponse.ReadOnly {
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val tagSet: List[zio.aws.s3.model.Tag.ReadOnly] = impl
      .tagSet()
      .asScala
      .map { item =>
        zio.aws.s3.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse
  ): zio.aws.s3.model.GetObjectTaggingResponse.ReadOnly = new Wrapper(impl)
}
