package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait IntelligentTieringAccessTier {
  def unwrap
      : software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier
}
object IntelligentTieringAccessTier {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier
  ): zio.aws.s3.model.IntelligentTieringAccessTier = value match {
    case software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier.ARCHIVE_ACCESS =>
      val r = ARCHIVE_ACCESS
      r
    case software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier.DEEP_ARCHIVE_ACCESS =>
      val r = DEEP_ARCHIVE_ACCESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.IntelligentTieringAccessTier {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier =
      software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier.UNKNOWN_TO_SDK_VERSION
  }
  case object ARCHIVE_ACCESS
      extends zio.aws.s3.model.IntelligentTieringAccessTier {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier =
      software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier.ARCHIVE_ACCESS
  }
  case object DEEP_ARCHIVE_ACCESS
      extends zio.aws.s3.model.IntelligentTieringAccessTier {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier =
      software.amazon.awssdk.services.s3.model.IntelligentTieringAccessTier.DEEP_ARCHIVE_ACCESS
  }
}
