package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InventoryDestination(
    s3BucketDestination: zio.aws.s3.model.InventoryS3BucketDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryDestination = {
    import InventoryDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryDestination
      .builder()
      .s3BucketDestination(s3BucketDestination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.InventoryDestination.ReadOnly =
    zio.aws.s3.model.InventoryDestination.wrap(buildAwsValue())
}
object InventoryDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.InventoryDestination =
      zio.aws.s3.model.InventoryDestination(s3BucketDestination.asEditable)
    def s3BucketDestination
        : zio.aws.s3.model.InventoryS3BucketDestination.ReadOnly
    def getS3BucketDestination: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.InventoryS3BucketDestination.ReadOnly
    ] = ZIO.succeed(s3BucketDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryDestination
  ) extends zio.aws.s3.model.InventoryDestination.ReadOnly {
    override val s3BucketDestination
        : zio.aws.s3.model.InventoryS3BucketDestination.ReadOnly =
      zio.aws.s3.model.InventoryS3BucketDestination
        .wrap(impl.s3BucketDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryDestination
  ): zio.aws.s3.model.InventoryDestination.ReadOnly = new Wrapper(impl)
}
