package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JSONInput(
    `type`: Optional[zio.aws.s3.model.JSONType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.JSONInput = {
    import JSONInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.JSONInput
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.JSONInput.ReadOnly =
    zio.aws.s3.model.JSONInput.wrap(buildAwsValue())
}
object JSONInput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.JSONInput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.JSONInput =
      zio.aws.s3.model.JSONInput(`type`.map(value => value))
    def `type`: Optional[zio.aws.s3.model.JSONType]
    def getType: ZIO[Any, AwsError, zio.aws.s3.model.JSONType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.JSONInput
  ) extends zio.aws.s3.model.JSONInput.ReadOnly {
    override val `type`: Optional[zio.aws.s3.model.JSONType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.s3.model.JSONType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.JSONInput
  ): zio.aws.s3.model.JSONInput.ReadOnly = new Wrapper(impl)
}
