package zio.aws.s3.model
import zio.aws.s3.model.primitives.RecordDelimiter
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JSONOutput(
    recordDelimiter: Optional[RecordDelimiter] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.JSONOutput = {
    import JSONOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.JSONOutput
      .builder()
      .optionallyWith(
        recordDelimiter.map(value =>
          RecordDelimiter.unwrap(value): java.lang.String
        )
      )(_.recordDelimiter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.JSONOutput.ReadOnly =
    zio.aws.s3.model.JSONOutput.wrap(buildAwsValue())
}
object JSONOutput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.JSONOutput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.JSONOutput =
      zio.aws.s3.model.JSONOutput(recordDelimiter.map(value => value))
    def recordDelimiter: Optional[RecordDelimiter]
    def getRecordDelimiter: ZIO[Any, AwsError, RecordDelimiter] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.JSONOutput
  ) extends zio.aws.s3.model.JSONOutput.ReadOnly {
    override val recordDelimiter: Optional[RecordDelimiter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordDelimiter())
        .map(value => zio.aws.s3.model.primitives.RecordDelimiter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.JSONOutput
  ): zio.aws.s3.model.JSONOutput.ReadOnly = new Wrapper(impl)
}
