package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ObjectSizeLessThanBytes,
  ObjectSizeGreaterThanBytes,
  Prefix
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LifecycleRuleAndOperator(
    prefix: Optional[Prefix] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.s3.model.Tag]] = Optional.Absent,
    objectSizeGreaterThan: Optional[ObjectSizeGreaterThanBytes] =
      Optional.Absent,
    objectSizeLessThan: Optional[ObjectSizeLessThanBytes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator = {
    import LifecycleRuleAndOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        objectSizeGreaterThan.map(value =>
          ObjectSizeGreaterThanBytes.unwrap(value): java.lang.Long
        )
      )(_.objectSizeGreaterThan)
      .optionallyWith(
        objectSizeLessThan.map(value =>
          ObjectSizeLessThanBytes.unwrap(value): java.lang.Long
        )
      )(_.objectSizeLessThan)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly =
    zio.aws.s3.model.LifecycleRuleAndOperator.wrap(buildAwsValue())
}
object LifecycleRuleAndOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.LifecycleRuleAndOperator =
      zio.aws.s3.model.LifecycleRuleAndOperator(
        prefix.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectSizeGreaterThan.map(value => value),
        objectSizeLessThan.map(value => value)
      )
    def prefix: Optional[Prefix]
    def tags: Optional[List[zio.aws.s3.model.Tag.ReadOnly]]
    def objectSizeGreaterThan: Optional[ObjectSizeGreaterThanBytes]
    def objectSizeLessThan: Optional[ObjectSizeLessThanBytes]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTags: ZIO[Any, AwsError, List[zio.aws.s3.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getObjectSizeGreaterThan
        : ZIO[Any, AwsError, ObjectSizeGreaterThanBytes] =
      AwsError.unwrapOptionField("objectSizeGreaterThan", objectSizeGreaterThan)
    def getObjectSizeLessThan: ZIO[Any, AwsError, ObjectSizeLessThanBytes] =
      AwsError.unwrapOptionField("objectSizeLessThan", objectSizeLessThan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ) extends zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly {
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tags: Optional[List[zio.aws.s3.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Tag.wrap(item)
          }.toList
        )
    override val objectSizeGreaterThan: Optional[ObjectSizeGreaterThanBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectSizeGreaterThan())
        .map(value =>
          zio.aws.s3.model.primitives.ObjectSizeGreaterThanBytes(value)
        )
    override val objectSizeLessThan: Optional[ObjectSizeLessThanBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectSizeLessThan())
        .map(value =>
          zio.aws.s3.model.primitives.ObjectSizeLessThanBytes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ): zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly = new Wrapper(impl)
}
