package zio.aws.s3.model
import zio.aws.s3.model.primitives.{Token, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBucketIntelligentTieringConfigurationsRequest(
    bucket: BucketName,
    continuationToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest = {
    import ListBucketIntelligentTieringConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsRequest.ReadOnly =
    zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListBucketIntelligentTieringConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsRequest =
      zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsRequest(
        bucket,
        continuationToken.map(value => value)
      )
    def bucket: BucketName
    def continuationToken: Optional[Token]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
  ) extends zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val continuationToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
  ): zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
