package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  MaxKeys,
  Prefix,
  AccountId,
  VersionIdMarker,
  Delimiter,
  BucketName,
  KeyMarker
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListObjectVersionsRequest(
    bucket: BucketName,
    delimiter: Optional[Delimiter] = Optional.Absent,
    encodingType: Optional[zio.aws.s3.model.EncodingType] = Optional.Absent,
    keyMarker: Optional[KeyMarker] = Optional.Absent,
    maxKeys: Optional[MaxKeys] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    versionIdMarker: Optional[VersionIdMarker] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest = {
    import ListObjectVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(
        keyMarker.map(value => KeyMarker.unwrap(value): java.lang.String)
      )(_.keyMarker)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        versionIdMarker.map(value =>
          VersionIdMarker.unwrap(value): java.lang.String
        )
      )(_.versionIdMarker)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectVersionsRequest.ReadOnly =
    zio.aws.s3.model.ListObjectVersionsRequest.wrap(buildAwsValue())
}
object ListObjectVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectVersionsRequest =
      zio.aws.s3.model.ListObjectVersionsRequest(
        bucket,
        delimiter.map(value => value),
        encodingType.map(value => value),
        keyMarker.map(value => value),
        maxKeys.map(value => value),
        prefix.map(value => value),
        versionIdMarker.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def delimiter: Optional[Delimiter]
    def encodingType: Optional[zio.aws.s3.model.EncodingType]
    def keyMarker: Optional[KeyMarker]
    def maxKeys: Optional[MaxKeys]
    def prefix: Optional[Prefix]
    def versionIdMarker: Optional[VersionIdMarker]
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getKeyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarker)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getVersionIdMarker: ZIO[Any, AwsError, VersionIdMarker] =
      AwsError.unwrapOptionField("versionIdMarker", versionIdMarker)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ) extends zio.aws.s3.model.ListObjectVersionsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val delimiter: Optional[Delimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val encodingType: Optional[zio.aws.s3.model.EncodingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodingType())
        .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val keyMarker: Optional[KeyMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.keyMarker())
      .map(value => zio.aws.s3.model.primitives.KeyMarker(value))
    override val maxKeys: Optional[MaxKeys] = zio.aws.core.internal
      .optionalFromNullable(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val versionIdMarker: Optional[VersionIdMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionIdMarker())
        .map(value => zio.aws.s3.model.primitives.VersionIdMarker(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ): zio.aws.s3.model.ListObjectVersionsRequest.ReadOnly = new Wrapper(impl)
}
