package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  MaxKeys,
  NextVersionIdMarker,
  Prefix,
  VersionIdMarker,
  Delimiter,
  BucketName,
  KeyMarker,
  IsTruncated,
  NextKeyMarker
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListObjectVersionsResponse(
    isTruncated: Optional[IsTruncated] = Optional.Absent,
    keyMarker: Optional[KeyMarker] = Optional.Absent,
    versionIdMarker: Optional[VersionIdMarker] = Optional.Absent,
    nextKeyMarker: Optional[NextKeyMarker] = Optional.Absent,
    nextVersionIdMarker: Optional[NextVersionIdMarker] = Optional.Absent,
    versions: Optional[Iterable[zio.aws.s3.model.ObjectVersion]] =
      Optional.Absent,
    deleteMarkers: Optional[Iterable[zio.aws.s3.model.DeleteMarkerEntry]] =
      Optional.Absent,
    name: Optional[BucketName] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    delimiter: Optional[Delimiter] = Optional.Absent,
    maxKeys: Optional[MaxKeys] = Optional.Absent,
    commonPrefixes: Optional[Iterable[zio.aws.s3.model.CommonPrefix]] =
      Optional.Absent,
    encodingType: Optional[zio.aws.s3.model.EncodingType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse = {
    import ListObjectVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        keyMarker.map(value => KeyMarker.unwrap(value): java.lang.String)
      )(_.keyMarker)
      .optionallyWith(
        versionIdMarker.map(value =>
          VersionIdMarker.unwrap(value): java.lang.String
        )
      )(_.versionIdMarker)
      .optionallyWith(
        nextKeyMarker.map(value =>
          NextKeyMarker.unwrap(value): java.lang.String
        )
      )(_.nextKeyMarker)
      .optionallyWith(
        nextVersionIdMarker.map(value =>
          NextVersionIdMarker.unwrap(value): java.lang.String
        )
      )(_.nextVersionIdMarker)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        deleteMarkers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deleteMarkers)
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly =
    zio.aws.s3.model.ListObjectVersionsResponse.wrap(buildAwsValue())
}
object ListObjectVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectVersionsResponse =
      zio.aws.s3.model.ListObjectVersionsResponse(
        isTruncated.map(value => value),
        keyMarker.map(value => value),
        versionIdMarker.map(value => value),
        nextKeyMarker.map(value => value),
        nextVersionIdMarker.map(value => value),
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteMarkers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        prefix.map(value => value),
        delimiter.map(value => value),
        maxKeys.map(value => value),
        commonPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encodingType.map(value => value)
      )
    def isTruncated: Optional[IsTruncated]
    def keyMarker: Optional[KeyMarker]
    def versionIdMarker: Optional[VersionIdMarker]
    def nextKeyMarker: Optional[NextKeyMarker]
    def nextVersionIdMarker: Optional[NextVersionIdMarker]
    def versions: Optional[List[zio.aws.s3.model.ObjectVersion.ReadOnly]]
    def deleteMarkers
        : Optional[List[zio.aws.s3.model.DeleteMarkerEntry.ReadOnly]]
    def name: Optional[BucketName]
    def prefix: Optional[Prefix]
    def delimiter: Optional[Delimiter]
    def maxKeys: Optional[MaxKeys]
    def commonPrefixes: Optional[List[zio.aws.s3.model.CommonPrefix.ReadOnly]]
    def encodingType: Optional[zio.aws.s3.model.EncodingType]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getKeyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarker)
    def getVersionIdMarker: ZIO[Any, AwsError, VersionIdMarker] =
      AwsError.unwrapOptionField("versionIdMarker", versionIdMarker)
    def getNextKeyMarker: ZIO[Any, AwsError, NextKeyMarker] =
      AwsError.unwrapOptionField("nextKeyMarker", nextKeyMarker)
    def getNextVersionIdMarker: ZIO[Any, AwsError, NextVersionIdMarker] =
      AwsError.unwrapOptionField("nextVersionIdMarker", nextVersionIdMarker)
    def getVersions
        : ZIO[Any, AwsError, List[zio.aws.s3.model.ObjectVersion.ReadOnly]] =
      AwsError.unwrapOptionField("versions", versions)
    def getDeleteMarkers: ZIO[Any, AwsError, List[
      zio.aws.s3.model.DeleteMarkerEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("deleteMarkers", deleteMarkers)
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getCommonPrefixes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      AwsError.unwrapOptionField("commonPrefixes", commonPrefixes)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ) extends zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly {
    override val isTruncated: Optional[IsTruncated] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val keyMarker: Optional[KeyMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.keyMarker())
      .map(value => zio.aws.s3.model.primitives.KeyMarker(value))
    override val versionIdMarker: Optional[VersionIdMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionIdMarker())
        .map(value => zio.aws.s3.model.primitives.VersionIdMarker(value))
    override val nextKeyMarker: Optional[NextKeyMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextKeyMarker())
      .map(value => zio.aws.s3.model.primitives.NextKeyMarker(value))
    override val nextVersionIdMarker: Optional[NextVersionIdMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextVersionIdMarker())
        .map(value => zio.aws.s3.model.primitives.NextVersionIdMarker(value))
    override val versions
        : Optional[List[zio.aws.s3.model.ObjectVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.ObjectVersion.wrap(item)
          }.toList
        )
    override val deleteMarkers
        : Optional[List[zio.aws.s3.model.DeleteMarkerEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteMarkers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.DeleteMarkerEntry.wrap(item)
          }.toList
        )
    override val name: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val delimiter: Optional[Delimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val maxKeys: Optional[MaxKeys] = zio.aws.core.internal
      .optionalFromNullable(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val commonPrefixes
        : Optional[List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commonPrefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.CommonPrefix.wrap(item)
          }.toList
        )
    override val encodingType: Optional[zio.aws.s3.model.EncodingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodingType())
        .map(value => zio.aws.s3.model.EncodingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ): zio.aws.s3.model.ListObjectVersionsResponse.ReadOnly = new Wrapper(impl)
}
