package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  Marker,
  MaxKeys,
  Prefix,
  NextMarker,
  Delimiter,
  BucketName,
  IsTruncated
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListObjectsResponse(
    isTruncated: Optional[IsTruncated] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    nextMarker: Optional[NextMarker] = Optional.Absent,
    contents: Optional[Iterable[zio.aws.s3.model.S3Object]] = Optional.Absent,
    name: Optional[BucketName] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    delimiter: Optional[Delimiter] = Optional.Absent,
    maxKeys: Optional[MaxKeys] = Optional.Absent,
    commonPrefixes: Optional[Iterable[zio.aws.s3.model.CommonPrefix]] =
      Optional.Absent,
    encodingType: Optional[zio.aws.s3.model.EncodingType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsResponse = {
    import ListObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsResponse
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        contents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contents)
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectsResponse.ReadOnly =
    zio.aws.s3.model.ListObjectsResponse.wrap(buildAwsValue())
}
object ListObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectsResponse =
      zio.aws.s3.model.ListObjectsResponse(
        isTruncated.map(value => value),
        marker.map(value => value),
        nextMarker.map(value => value),
        contents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        prefix.map(value => value),
        delimiter.map(value => value),
        maxKeys.map(value => value),
        commonPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encodingType.map(value => value)
      )
    def isTruncated: Optional[IsTruncated]
    def marker: Optional[Marker]
    def nextMarker: Optional[NextMarker]
    def contents: Optional[List[zio.aws.s3.model.S3Object.ReadOnly]]
    def name: Optional[BucketName]
    def prefix: Optional[Prefix]
    def delimiter: Optional[Delimiter]
    def maxKeys: Optional[MaxKeys]
    def commonPrefixes: Optional[List[zio.aws.s3.model.CommonPrefix.ReadOnly]]
    def encodingType: Optional[zio.aws.s3.model.EncodingType]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getContents
        : ZIO[Any, AwsError, List[zio.aws.s3.model.S3Object.ReadOnly]] =
      AwsError.unwrapOptionField("contents", contents)
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getCommonPrefixes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      AwsError.unwrapOptionField("commonPrefixes", commonPrefixes)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ) extends zio.aws.s3.model.ListObjectsResponse.ReadOnly {
    override val isTruncated: Optional[IsTruncated] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.s3.model.primitives.Marker(value))
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.s3.model.primitives.NextMarker(value))
    override val contents: Optional[List[zio.aws.s3.model.S3Object.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.S3Object.wrap(item)
          }.toList
        )
    override val name: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val delimiter: Optional[Delimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val maxKeys: Optional[MaxKeys] = zio.aws.core.internal
      .optionalFromNullable(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val commonPrefixes
        : Optional[List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commonPrefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.CommonPrefix.wrap(item)
          }.toList
        )
    override val encodingType: Optional[zio.aws.s3.model.EncodingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodingType())
        .map(value => zio.aws.s3.model.EncodingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ): zio.aws.s3.model.ListObjectsResponse.ReadOnly = new Wrapper(impl)
}
