package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait MetricsStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.MetricsStatus
}
object MetricsStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.MetricsStatus
  ): zio.aws.s3.model.MetricsStatus = value match {
    case software.amazon.awssdk.services.s3.model.MetricsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.MetricsStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.MetricsStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.MetricsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MetricsStatus =
      software.amazon.awssdk.services.s3.model.MetricsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3.model.MetricsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MetricsStatus =
      software.amazon.awssdk.services.s3.model.MetricsStatus.ENABLED
  }
  case object Disabled extends zio.aws.s3.model.MetricsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MetricsStatus =
      software.amazon.awssdk.services.s3.model.MetricsStatus.DISABLED
  }
}
