package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{VersionCount, Days}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NoncurrentVersionExpiration(
    noncurrentDays: Optional[Days] = Optional.Absent,
    newerNoncurrentVersions: Optional[VersionCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration = {
    import NoncurrentVersionExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .optionallyWith(
        newerNoncurrentVersions.map(value =>
          VersionCount.unwrap(value): Integer
        )
      )(_.newerNoncurrentVersions)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly =
    zio.aws.s3.model.NoncurrentVersionExpiration.wrap(buildAwsValue())
}
object NoncurrentVersionExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.NoncurrentVersionExpiration =
      zio.aws.s3.model.NoncurrentVersionExpiration(
        noncurrentDays.map(value => value),
        newerNoncurrentVersions.map(value => value)
      )
    def noncurrentDays: Optional[Days]
    def newerNoncurrentVersions: Optional[VersionCount]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
    def getNewerNoncurrentVersions: ZIO[Any, AwsError, VersionCount] = AwsError
      .unwrapOptionField("newerNoncurrentVersions", newerNoncurrentVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ) extends zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly {
    override val noncurrentDays: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.noncurrentDays())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val newerNoncurrentVersions: Optional[VersionCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newerNoncurrentVersions())
        .map(value => zio.aws.s3.model.primitives.VersionCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ): zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly = new Wrapper(impl)
}
