package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{VersionCount, Days}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NoncurrentVersionTransition(
    noncurrentDays: Optional[Days] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.TransitionStorageClass] =
      Optional.Absent,
    newerNoncurrentVersions: Optional[VersionCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition = {
    import NoncurrentVersionTransition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        newerNoncurrentVersions.map(value =>
          VersionCount.unwrap(value): Integer
        )
      )(_.newerNoncurrentVersions)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly =
    zio.aws.s3.model.NoncurrentVersionTransition.wrap(buildAwsValue())
}
object NoncurrentVersionTransition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.NoncurrentVersionTransition =
      zio.aws.s3.model.NoncurrentVersionTransition(
        noncurrentDays.map(value => value),
        storageClass.map(value => value),
        newerNoncurrentVersions.map(value => value)
      )
    def noncurrentDays: Optional[Days]
    def storageClass: Optional[zio.aws.s3.model.TransitionStorageClass]
    def newerNoncurrentVersions: Optional[VersionCount]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3.model.TransitionStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getNewerNoncurrentVersions: ZIO[Any, AwsError, VersionCount] = AwsError
      .unwrapOptionField("newerNoncurrentVersions", newerNoncurrentVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ) extends zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly {
    override val noncurrentDays: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.noncurrentDays())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val storageClass
        : Optional[zio.aws.s3.model.TransitionStorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.TransitionStorageClass.wrap(value))
    override val newerNoncurrentVersions: Optional[VersionCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newerNoncurrentVersions())
        .map(value => zio.aws.s3.model.primitives.VersionCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ): zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly = new Wrapper(impl)
}
