package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ObjectLockRetentionMode {
  def unwrap: software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode
}
object ObjectLockRetentionMode {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode
  ): zio.aws.s3.model.ObjectLockRetentionMode = value match {
    case software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode.GOVERNANCE =>
      val r = GOVERNANCE
      r
    case software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode.COMPLIANCE =>
      val r = COMPLIANCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.ObjectLockRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode =
      software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object GOVERNANCE extends zio.aws.s3.model.ObjectLockRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode =
      software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode.GOVERNANCE
  }
  case object COMPLIANCE extends zio.aws.s3.model.ObjectLockRetentionMode {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode =
      software.amazon.awssdk.services.s3.model.ObjectLockRetentionMode.COMPLIANCE
  }
}
