package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ObjectOwnership {
  def unwrap: software.amazon.awssdk.services.s3.model.ObjectOwnership
}
object ObjectOwnership {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ObjectOwnership
  ): zio.aws.s3.model.ObjectOwnership = value match {
    case software.amazon.awssdk.services.s3.model.ObjectOwnership.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ObjectOwnership.BUCKET_OWNER_PREFERRED =>
      val r = BucketOwnerPreferred
      r
    case software.amazon.awssdk.services.s3.model.ObjectOwnership.OBJECT_WRITER =>
      val r = ObjectWriter
      r
    case software.amazon.awssdk.services.s3.model.ObjectOwnership.BUCKET_OWNER_ENFORCED =>
      val r = BucketOwnerEnforced
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.ObjectOwnership {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectOwnership =
      software.amazon.awssdk.services.s3.model.ObjectOwnership.UNKNOWN_TO_SDK_VERSION
  }
  case object BucketOwnerPreferred extends zio.aws.s3.model.ObjectOwnership {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectOwnership =
      software.amazon.awssdk.services.s3.model.ObjectOwnership.BUCKET_OWNER_PREFERRED
  }
  case object ObjectWriter extends zio.aws.s3.model.ObjectOwnership {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectOwnership =
      software.amazon.awssdk.services.s3.model.ObjectOwnership.OBJECT_WRITER
  }
  case object BucketOwnerEnforced extends zio.aws.s3.model.ObjectOwnership {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectOwnership =
      software.amazon.awssdk.services.s3.model.ObjectOwnership.BUCKET_OWNER_ENFORCED
  }
}
