package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ObjectVersionStorageClass {
  def unwrap: software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass
}
object ObjectVersionStorageClass {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass
  ): zio.aws.s3.model.ObjectVersionStorageClass = value match {
    case software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.ObjectVersionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.s3.model.ObjectVersionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass =
      software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass.STANDARD
  }
}
