package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait Payer {
  def unwrap: software.amazon.awssdk.services.s3.model.Payer
}
object Payer {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.Payer
  ): zio.aws.s3.model.Payer = value match {
    case software.amazon.awssdk.services.s3.model.Payer.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.Payer.REQUESTER =>
      val r = Requester
      r
    case software.amazon.awssdk.services.s3.model.Payer.BUCKET_OWNER =>
      val r = BucketOwner
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.Payer {
    override def unwrap: software.amazon.awssdk.services.s3.model.Payer =
      software.amazon.awssdk.services.s3.model.Payer.UNKNOWN_TO_SDK_VERSION
  }
  case object Requester extends zio.aws.s3.model.Payer {
    override def unwrap: software.amazon.awssdk.services.s3.model.Payer =
      software.amazon.awssdk.services.s3.model.Payer.REQUESTER
  }
  case object BucketOwner extends zio.aws.s3.model.Payer {
    override def unwrap: software.amazon.awssdk.services.s3.model.Payer =
      software.amazon.awssdk.services.s3.model.Payer.BUCKET_OWNER
  }
}
