package zio.aws.s3.model
import scala.jdk.CollectionConverters._
sealed trait Protocol {
  def unwrap: software.amazon.awssdk.services.s3.model.Protocol
}
object Protocol {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.Protocol
  ): zio.aws.s3.model.Protocol = value match {
    case software.amazon.awssdk.services.s3.model.Protocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.Protocol.HTTP =>
      val r = http
      r
    case software.amazon.awssdk.services.s3.model.Protocol.HTTPS =>
      val r = https
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.s3.model.Protocol =
      software.amazon.awssdk.services.s3.model.Protocol.UNKNOWN_TO_SDK_VERSION
  }
  case object http extends zio.aws.s3.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.s3.model.Protocol =
      software.amazon.awssdk.services.s3.model.Protocol.HTTP
  }
  case object https extends zio.aws.s3.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.s3.model.Protocol =
      software.amazon.awssdk.services.s3.model.Protocol.HTTPS
  }
}
