package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutBucketLifecycleConfigurationRequest(
    bucket: BucketName,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    lifecycleConfiguration: Optional[
      zio.aws.s3.model.BucketLifecycleConfiguration
    ] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest = {
    import PutBucketLifecycleConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        lifecycleConfiguration.map(value => value.buildAwsValue())
      )(_.lifecycleConfiguration)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.PutBucketLifecycleConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketLifecycleConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketLifecycleConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketLifecycleConfigurationRequest =
      zio.aws.s3.model.PutBucketLifecycleConfigurationRequest(
        bucket,
        checksumAlgorithm.map(value => value),
        lifecycleConfiguration.map(value => value.asEditable),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def lifecycleConfiguration
        : Optional[zio.aws.s3.model.BucketLifecycleConfiguration.ReadOnly]
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getLifecycleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.BucketLifecycleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleConfiguration",
      lifecycleConfiguration
    )
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest
  ) extends zio.aws.s3.model.PutBucketLifecycleConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val lifecycleConfiguration
        : Optional[zio.aws.s3.model.BucketLifecycleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleConfiguration())
        .map(value => zio.aws.s3.model.BucketLifecycleConfiguration.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest
  ): zio.aws.s3.model.PutBucketLifecycleConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
