package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, MFA, ContentMD5, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutBucketVersioningRequest(
    bucket: BucketName,
    contentMD5: Optional[ContentMD5] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    mfa: Optional[MFA] = Optional.Absent,
    versioningConfiguration: zio.aws.s3.model.VersioningConfiguration,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest = {
    import PutBucketVersioningRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(mfa.map(value => MFA.unwrap(value): java.lang.String))(
        _.mfa
      )
      .versioningConfiguration(versioningConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketVersioningRequest.ReadOnly =
    zio.aws.s3.model.PutBucketVersioningRequest.wrap(buildAwsValue())
}
object PutBucketVersioningRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketVersioningRequest =
      zio.aws.s3.model.PutBucketVersioningRequest(
        bucket,
        contentMD5.map(value => value),
        checksumAlgorithm.map(value => value),
        mfa.map(value => value),
        versioningConfiguration.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentMD5: Optional[ContentMD5]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def mfa: Optional[MFA]
    def versioningConfiguration
        : zio.aws.s3.model.VersioningConfiguration.ReadOnly
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getMfa: ZIO[Any, AwsError, MFA] = AwsError.unwrapOptionField("mfa", mfa)
    def getVersioningConfiguration
        : ZIO[Any, Nothing, zio.aws.s3.model.VersioningConfiguration.ReadOnly] =
      ZIO.succeed(versioningConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest
  ) extends zio.aws.s3.model.PutBucketVersioningRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Optional[ContentMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val mfa: Optional[MFA] = zio.aws.core.internal
      .optionalFromNullable(impl.mfa())
      .map(value => zio.aws.s3.model.primitives.MFA(value))
    override val versioningConfiguration
        : zio.aws.s3.model.VersioningConfiguration.ReadOnly =
      zio.aws.s3.model.VersioningConfiguration
        .wrap(impl.versioningConfiguration())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest
  ): zio.aws.s3.model.PutBucketVersioningRequest.ReadOnly = new Wrapper(impl)
}
