package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, ContentMD5, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutBucketWebsiteRequest(
    bucket: BucketName,
    contentMD5: Optional[ContentMD5] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    websiteConfiguration: zio.aws.s3.model.WebsiteConfiguration,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest = {
    import PutBucketWebsiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .websiteConfiguration(websiteConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketWebsiteRequest.ReadOnly =
    zio.aws.s3.model.PutBucketWebsiteRequest.wrap(buildAwsValue())
}
object PutBucketWebsiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketWebsiteRequest =
      zio.aws.s3.model.PutBucketWebsiteRequest(
        bucket,
        contentMD5.map(value => value),
        checksumAlgorithm.map(value => value),
        websiteConfiguration.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentMD5: Optional[ContentMD5]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def websiteConfiguration: zio.aws.s3.model.WebsiteConfiguration.ReadOnly
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getWebsiteConfiguration
        : ZIO[Any, Nothing, zio.aws.s3.model.WebsiteConfiguration.ReadOnly] =
      ZIO.succeed(websiteConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest
  ) extends zio.aws.s3.model.PutBucketWebsiteRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Optional[ContentMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val websiteConfiguration
        : zio.aws.s3.model.WebsiteConfiguration.ReadOnly =
      zio.aws.s3.model.WebsiteConfiguration.wrap(impl.websiteConfiguration())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest
  ): zio.aws.s3.model.PutBucketWebsiteRequest.ReadOnly = new Wrapper(impl)
}
