package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutObjectLegalHoldResponse(
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse = {
    import PutObjectLegalHoldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectLegalHoldResponse.ReadOnly =
    zio.aws.s3.model.PutObjectLegalHoldResponse.wrap(buildAwsValue())
}
object PutObjectLegalHoldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectLegalHoldResponse =
      zio.aws.s3.model
        .PutObjectLegalHoldResponse(requestCharged.map(value => value))
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse
  ) extends zio.aws.s3.model.PutObjectLegalHoldResponse.ReadOnly {
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse
  ): zio.aws.s3.model.PutObjectLegalHoldResponse.ReadOnly = new Wrapper(impl)
}
