package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ContentMD5,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutObjectTaggingRequest(
    bucket: BucketName,
    key: ObjectKey,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    contentMD5: Optional[ContentMD5] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    tagging: zio.aws.s3.model.Tagging,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest = {
    import PutObjectTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .tagging(tagging.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectTaggingRequest.ReadOnly =
    zio.aws.s3.model.PutObjectTaggingRequest.wrap(buildAwsValue())
}
object PutObjectTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectTaggingRequest =
      zio.aws.s3.model.PutObjectTaggingRequest(
        bucket,
        key,
        versionId.map(value => value),
        contentMD5.map(value => value),
        checksumAlgorithm.map(value => value),
        tagging.asEditable,
        expectedBucketOwner.map(value => value),
        requestPayer.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def versionId: Optional[ObjectVersionId]
    def contentMD5: Optional[ContentMD5]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def tagging: zio.aws.s3.model.Tagging.ReadOnly
    def expectedBucketOwner: Optional[AccountId]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getTagging: ZIO[Any, Nothing, zio.aws.s3.model.Tagging.ReadOnly] =
      ZIO.succeed(tagging)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest
  ) extends zio.aws.s3.model.PutObjectTaggingRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val contentMD5: Optional[ContentMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val tagging: zio.aws.s3.model.Tagging.ReadOnly =
      zio.aws.s3.model.Tagging.wrap(impl.tagging())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest
  ): zio.aws.s3.model.PutObjectTaggingRequest.ReadOnly = new Wrapper(impl)
}
