package zio.aws.s3.model
import zio.aws.s3.model.primitives.RestoreOutputPath
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreObjectResponse(
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent,
    restoreOutputPath: Optional[RestoreOutputPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RestoreObjectResponse = {
    import RestoreObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RestoreObjectResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(
        restoreOutputPath.map(value =>
          RestoreOutputPath.unwrap(value): java.lang.String
        )
      )(_.restoreOutputPath)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RestoreObjectResponse.ReadOnly =
    zio.aws.s3.model.RestoreObjectResponse.wrap(buildAwsValue())
}
object RestoreObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RestoreObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RestoreObjectResponse =
      zio.aws.s3.model.RestoreObjectResponse(
        requestCharged.map(value => value),
        restoreOutputPath.map(value => value)
      )
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def restoreOutputPath: Optional[RestoreOutputPath]
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getRestoreOutputPath: ZIO[Any, AwsError, RestoreOutputPath] =
      AwsError.unwrapOptionField("restoreOutputPath", restoreOutputPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RestoreObjectResponse
  ) extends zio.aws.s3.model.RestoreObjectResponse.ReadOnly {
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val restoreOutputPath: Optional[RestoreOutputPath] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreOutputPath())
        .map(value => zio.aws.s3.model.primitives.RestoreOutputPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RestoreObjectResponse
  ): zio.aws.s3.model.RestoreObjectResponse.ReadOnly = new Wrapper(impl)
}
