package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3KeyFilter(
    filterRules: Optional[Iterable[zio.aws.s3.model.FilterRule]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3KeyFilter = {
    import S3KeyFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3KeyFilter
      .builder()
      .optionallyWith(
        filterRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterRules)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.S3KeyFilter.ReadOnly =
    zio.aws.s3.model.S3KeyFilter.wrap(buildAwsValue())
}
object S3KeyFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3KeyFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.S3KeyFilter = zio.aws.s3.model.S3KeyFilter(
      filterRules.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def filterRules: Optional[List[zio.aws.s3.model.FilterRule.ReadOnly]]
    def getFilterRules
        : ZIO[Any, AwsError, List[zio.aws.s3.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("filterRules", filterRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.S3KeyFilter
  ) extends zio.aws.s3.model.S3KeyFilter.ReadOnly {
    override val filterRules
        : Optional[List[zio.aws.s3.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.FilterRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3KeyFilter
  ): zio.aws.s3.model.S3KeyFilter.ReadOnly = new Wrapper(impl)
}
