package zio.aws.s3.model
import zio.aws.s3.model.primitives.{LocationPrefix, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Location(
    bucketName: BucketName,
    prefix: LocationPrefix,
    encryption: Optional[zio.aws.s3.model.Encryption] = Optional.Absent,
    cannedACL: Optional[zio.aws.s3.model.ObjectCannedACL] = Optional.Absent,
    accessControlList: Optional[Iterable[zio.aws.s3.model.Grant]] =
      Optional.Absent,
    tagging: Optional[zio.aws.s3.model.Tagging] = Optional.Absent,
    userMetadata: Optional[Iterable[zio.aws.s3.model.MetadataEntry]] =
      Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3Location
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .prefix(LocationPrefix.unwrap(prefix): java.lang.String)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(cannedACL.map(value => value.unwrap))(_.cannedACL)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(tagging.map(value => value.buildAwsValue()))(_.tagging)
      .optionallyWith(
        userMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userMetadata)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.S3Location.ReadOnly =
    zio.aws.s3.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3Location] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.S3Location = zio.aws.s3.model.S3Location(
      bucketName,
      prefix,
      encryption.map(value => value.asEditable),
      cannedACL.map(value => value),
      accessControlList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tagging.map(value => value.asEditable),
      userMetadata.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      storageClass.map(value => value)
    )
    def bucketName: BucketName
    def prefix: LocationPrefix
    def encryption: Optional[zio.aws.s3.model.Encryption.ReadOnly]
    def cannedACL: Optional[zio.aws.s3.model.ObjectCannedACL]
    def accessControlList: Optional[List[zio.aws.s3.model.Grant.ReadOnly]]
    def tagging: Optional[zio.aws.s3.model.Tagging.ReadOnly]
    def userMetadata: Optional[List[zio.aws.s3.model.MetadataEntry.ReadOnly]]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getPrefix: ZIO[Any, Nothing, LocationPrefix] = ZIO.succeed(prefix)
    def getEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.Encryption.ReadOnly] =
      AwsError.unwrapOptionField("encryption", encryption)
    def getCannedACL: ZIO[Any, AwsError, zio.aws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("cannedACL", cannedACL)
    def getAccessControlList
        : ZIO[Any, AwsError, List[zio.aws.s3.model.Grant.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getTagging: ZIO[Any, AwsError, zio.aws.s3.model.Tagging.ReadOnly] =
      AwsError.unwrapOptionField("tagging", tagging)
    def getUserMetadata
        : ZIO[Any, AwsError, List[zio.aws.s3.model.MetadataEntry.ReadOnly]] =
      AwsError.unwrapOptionField("userMetadata", userMetadata)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.S3Location
  ) extends zio.aws.s3.model.S3Location.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucketName())
    override val prefix: LocationPrefix =
      zio.aws.s3.model.primitives.LocationPrefix(impl.prefix())
    override val encryption: Optional[zio.aws.s3.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.s3.model.Encryption.wrap(value))
    override val cannedACL: Optional[zio.aws.s3.model.ObjectCannedACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cannedACL())
        .map(value => zio.aws.s3.model.ObjectCannedACL.wrap(value))
    override val accessControlList
        : Optional[List[zio.aws.s3.model.Grant.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Grant.wrap(item)
          }.toList
        )
    override val tagging: Optional[zio.aws.s3.model.Tagging.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagging())
        .map(value => zio.aws.s3.model.Tagging.wrap(value))
    override val userMetadata
        : Optional[List[zio.aws.s3.model.MetadataEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.MetadataEntry.wrap(item)
          }.toList
        )
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3Location
  ): zio.aws.s3.model.S3Location.ReadOnly = new Wrapper(impl)
}
